/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/

/** 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : JavaBean.Coffee_Data.java
 * Desprition : This JavaBean class is responsible for getting and setting
 * properties related to Coffee Data.
 * 
 */
package JavaBeans;
/**
 * @author student
 *
 * This class is being used for holding all the information realting to coffee types.
 * 
 */
public class Coffee_Data {

	private String type;
	private String size;
	private String itemCode;
	private String description;
	private double price;

	/**
	 * This is the constructor for Coffee_Data.java
	 */
	public Coffee_Data() {
	}

	/**
	 * This is the constructor for Coffee_Data.java
	 */
	public Coffee_Data(
		String code,
		String type,
		String size,
		double p,
		String desc) {
		this.itemCode = code;
		this.type = type;
		this.size = size;
		this.price = p;
		this.description = desc;

	}


	/**
	 * This method is being used for setting the type field.
	 * @param type Type of coffee. 
	 * @return void
	 */
	public void setType(String type) {
		this.type = type;
	}
	
	/**
	 * This method is being used for getting the type field.
	 * @return String Type of coffee.
	 */
	public String getType() {
		return this.type;
	}

	/**
	 * This method is being used for setting the size field.
	 * @param size Coffee size. 
	 * @return void
	 */
	public void setSize(String size) {
		this.size = size;
	}
	
	
	/**
	 * This method is being used for getting the size field.
	 * @return String Coffee size.
	 */
	public String getSize() {
		return this.size;
	}

	
	/**
	 * This method is being used for setting the itemcode field.
	 * @param itemCode Coffee item code.
	 * @return void
	 */
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}
	
	
	/**
	 * This method is being used for getting the itemcode field.
	 * @return String Coffee item code.
	 */
	public String getItemCode() {
		return this.itemCode;
	}

	/**
	 * This method is being used for setting the description field.
	 * @param desc Coffee description.
	 * @return void
	 */
	public void setDescription(String desc) {
		this.description = desc;
	}
	
	
	/**
	 * This method is being used for getting the description field.
	 * @return String Coffee description.
	 */
	public String getDescription() {
		return this.description;
	}

	
	/**
	 * This method is being used for getting the servicecode field.
	 * @return String Coffee service code.
	 */
	public String getServiceCode() {
		return "CoffeeServiceCode";
	}
	
	/**
	 * This method is being used for getting the servicerequest.
	 * @return String Coffee service request.
	 */
	public String getServiceRequest() {
		return "Request";
	}
	
	/**
	 * This method is being used for getting the serviceresponse.
	 * @return String Coffee service response.
	 */
	public String getServiceResponse() {
		return "Response";
	}
	
	
	/**
	 * This method is being used for getting the price field.
	 * @return double Coffee price.
	 */
	public double getPrice() {
		return this.price;
	}
}
